#include <16F877A.h>
#use delay(crystal=20MHz)

// ---- Select ONE demo ----
#define RUN_TIMER_INTERRUPT
//#define RUN_EXT_INTERRUPT
//#define RUN_PRINT_ICD
//#define RUN_EXT_EEPROM

//------------------------------------------------------------
// 1. Timer Interrupt Demo
#int_TIMER1
void timer1_isr() {
   set_timer1(3036);  // Set the start value
   output_toggle(PIN_B4);  // Blink LED without blocking
}

void demo_timer_interrupt() {
   setup_timer_1(T1_INTERNAL | T1_DIV_BY_8);  // Tick is 1.6us
   enable_interrupts(INT_TIMER1);
   enable_interrupts(GLOBAL);
   while(TRUE);  // Do nothing, LED still blinks
}

//------------------------------------------------------------
// 2. External Interrupt Demo
#int_EXT
void ext_isr() {
   output_toggle(PIN_B4);
}

void demo_ext_interrupt() {
   output_low(PIN_B4);          // Initialize LED off
   port_b_pullups(TRUE);        // Set the input pullups
   ext_int_edge(H_TO_L);        // Trigger on falling edge (button press to ground)
   enable_interrupts(INT_EXT);
   enable_interrupts(GLOBAL);
   while(TRUE);
}

//------------------------------------------------------------
// ---- ICD for printing ----
#use rs232(icd)

// 3. Print using ICD Demo
void demo_print_icd() {
   printf("=== System Boot ===\r\n");
   // Print environmental variables
   printf("Device     : %s\r\n", getenv("DEVICE"));
   printf("Clock Speed: %lu Hz\r\n", getenv("CLOCK"));
   printf("Version    : %s\r\n", getenv("VERSION_STRING"));  // Compiler version
   // Print pre-defined identifiers
   printf("Build      : %s %s\r\n", __DATE__, __TIME__);
   printf("Filename   : %s\r\n", __FILENAME__);
   while(TRUE) {
      if (kbhit()) {       // Check if a character has been received
         char c = getc();  // Read the character
         printf("You typed: %c\r\n", c);
      }
   }
}

//------------------------------------------------------------
// ---- Include driver for the external EEPROM ----
#include <9356.c>

// 4. External EEPROM Demo
void demo_ext_eeprom() {
   int8 val;
   init_ext_eeprom();
   write_ext_eeprom(0, 234);
   val = read_ext_eeprom(0);
   printf("EEPROM read: %u\r\n", val);
   while(TRUE);
}

//------------------------------------------------------------
void main() {
   #ifdef RUN_TIMER_INTERRUPT
      demo_timer_interrupt();
   #endif

   #ifdef RUN_EXT_INTERRUPT
      demo_ext_interrupt();
   #endif

   #ifdef RUN_PRINT_ICD
      demo_print_icd();
   #endif

   #ifdef RUN_EXT_EEPROM
      demo_ext_eeprom();
   #endif
}
